package edu.uky.ai.ml.nn;

/**
 * An example is an individual data point that is part of a larger database.
 * 
 * @author Stephen G. Ware
 */
public class Example {

	/** The input given to the neural network */
	public final double[] input;
	
	/** The output that neural network should give */
	public final double[] output;
	
	/** A class label associated with this output */
	public final String label;
	
	/**
	 * Constructs a new training example.
	 * 
	 * @param input the input given to the neural network
	 * @param output the output the network should give
	 * @param label a class label associated with the output
	 */
	public Example(double[] input, double[] output, String label) {
		this.input = input;
		this.output = output;
		this.label = label;
	}
}
